require(asset.documents.FullOrbitViewer)
require(asset.documents.immediateUI)
-- Main.lua

function setup()
    viewer.mode = FULLSCREEN
    
    board = BoardModel()
    board:spawnInitialTiles()
    
    renderer = HexRenderer2D(board, 42)
    ui = UI2D(board, renderer)
end

function draw()
    background(20,20,40)
    renderer:update()
    ui:drawMatchCount()
end

function touched(t)
    if t.state ~= ENDED then return end
    
    -- rotate candidate if tapped
    local q,r = ui:candidateTapped(t)
    if q then
        board:rotateTile(q, r, "left")
        return
    end
    
    -- otherwise move candidate
    local q2,r2 = ui:playableHexTapped(t)
    if q2 then
        ui:moveCandidateTo(q2,r2)
    end
end